/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.NoSuchConfigEntryException;
import com.floragunn.searchguard.configuration.SgConfigEntry;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;

public abstract class DocumentLevelConfigApi {
    private static final Logger log = LogManager.getLogger(DocumentLevelConfigApi.class);

    public static class PatchAction
    extends Action<Request, StandardResponse> {
        protected PatchAction(String name) {
            super(name, Request::new, StandardResponse::new);
        }

        public static class Handler<T>
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configRepository;
            private final CType<T> configType;

            @Inject
            public Handler(Action<Request, StandardResponse> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configRepository) {
                super(action, handlerDependencies);
                this.configRepository = configRepository;
                this.configType = configType;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.configRepository.applyPatch(this.configType, request.getId(), request.getPatch(), request.getIfMatch(), ConfigurationRepository.PatchDefaultHandling.FAIL_ON_MISSING_DOCUMENT);
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(null, e.getMessage(), (Object)e.getValidationErrors());
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                    catch (Exception e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }

        public static class Request
        extends Action.Request {
            private final String id;
            private final DocPatch patch;

            public Request(String id, DocPatch patch) {
                this.id = id;
                this.patch = patch;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                ValidationErrors validationErrors = new ValidationErrors();
                ValidatingDocNode vNode = new ValidatingDocNode(message.requiredDocNode(), validationErrors);
                this.id = vNode.get("id").required().asString();
                this.patch = (DocPatch)vNode.get("patch").required().by(DocPatch::parseTyped);
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"patch", (Object)this.patch);
            }

            public DocPatch getPatch() {
                return this.patch;
            }

            public String getId() {
                return this.id;
            }
        }
    }

    public static class PutAction
    extends Action<Request, StandardResponse> {
        protected PutAction(String name) {
            super(name, Request::new, StandardResponse::new);
        }

        public static class Handler<T>
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configurationRepository;
            private final CType<T> configType;

            @Inject
            public Handler(Action<Request, StandardResponse> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository) {
                super(action, handlerDependencies);
                this.configurationRepository = configurationRepository;
                this.configType = configType;
            }

            protected final CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    try {
                        Object entry = this.configType.getParser().parse(DocNode.wrap(request.getConfig()), (Parser.Context)this.configurationRepository.getParserContext()).get();
                        this.configurationRepository.addOrUpdate(this.configType, request.getId(), entry, request.getIfMatch());
                        return new StandardResponse(200).message("Configuration has been updated");
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(e);
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while updating configuration", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                });
            }
        }

        public static class Request
        extends Action.Request {
            private final String id;
            private final Map<String, Object> config;

            public Request(String id, Map<String, Object> config) {
                this.id = id;
                this.config = config;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                DocNode docNode = message.requiredDocNode();
                this.id = docNode.getAsString("id");
                this.config = docNode.getAsNode("config").toMap();
            }

            public Map<String, Object> getConfig() {
                return this.config;
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"config", this.config);
            }

            public String getId() {
                return this.id;
            }
        }
    }

    public static class GetAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        protected GetAction(String name) {
            super(name, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static abstract class Handler<T>
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ConfigurationRepository configurationRepository;
            private final CType<T> configType;

            @Inject
            public Handler(Action<StandardRequests.IdRequest, StandardResponse> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository, BaseDependencies baseDependencies) {
                super(action, handlerDependencies);
                this.configType = configType;
                this.configurationRepository = configurationRepository;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        SgConfigEntry<T> entry = this.configurationRepository.getConfigEntryFromIndex(this.configType, request.getId(), "GET API Request");
                        return new StandardResponse(200).data(entry.toRedactedBasicObject()).eTag(entry.getETag());
                    }
                    catch (NoSuchConfigEntryException e) {
                        log.info(e.getMessage());
                        return new StandardResponse(404).error(e.getMessage());
                    }
                    catch (Exception e) {
                        log.error("Error while getting user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }
    }
}

